/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.utils.PathUtils;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.AbstractFilePredicate;
import org.sonarsource.sonarlint.core.container.analysis.filesystem.InputPathCache;

class AbsolutePathPredicate
extends AbstractFilePredicate {
    private final String path;

    AbsolutePathPredicate(String path) {
        this.path = PathUtils.sanitize(path);
    }

    @Override
    public boolean apply(InputFile f) {
        return this.path.equals(f.absolutePath());
    }

    @Override
    public Iterable<InputFile> get(FileSystem.Index index) {
        InputFile f = ((InputPathCache)index).inputFile(Paths.get(this.path, new String[0]));
        return f != null ? Arrays.asList(f) : Collections.emptyList();
    }

    @Override
    public int priority() {
        return 20;
    }
}

